


/******************************************************************************************
 *                                                                                        *
 * Ex2.      :   Read BCD Code(4bit) From Touch PAD Key 4x4 Out To RS232                  *
 *                  (Format:Press Key SHIFT + key Other)  	                              *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 *                                                                                        *
 * Target MCU     : ATMEL AVR-MEGA128                                                     *
 *       	      : X-TAL : 16 MHz                                                        *
 *                                                                                        *
 * Editor         : AVR Studio 4.15 Build 623                                             *
 * Compiler       : WinAVR-20081205                                                       *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                  *
 * Last Update    : 09/September/2014                                                     *
 *																				          *
 * Port Interface :  -- MCU-AVR-Mega128--	  	  	      -- Key Touch PAD 4x4 --         *
 *                                                                                        *
 *                   PA0(Input)       Connect                 BCD Colum 1                 * 
 *                   PA1(Input)       Connect                 BCD Colum 2                 *
 *                   PA2(Input)       Connect			      BCD Colum 4                 *
 *                   PA3(Input)		  Connect				  BCD Colum 8                 *
 *					 PA4(Input)	      Connect                 T#/R Ststus 1Key            *
 *                   PA5(Input)       Connec                  SHIF# Statu 2Key            *
 *																						  *
 *       Uart0    :  PE0 = RXDO 	  Connect                 Tx Comport PC               *  
 *                   PE1 = TXD0		  Connect                 Rx Comport PC               * 												  *
 *                   Baud Rate = 9600 at Clock 16 Mhz                                     *
 *                                                                                        *
 *    LED DISPLAY : PC[0..7]	           Connect	              LED Common Anode 		  *
 *                                                                						  *  
 *                                                                             5V		  *
 *                                                                             -+- 		  *
 *                                                              560      \\     |  		  *
 *                                                       PC0 --/\/\/\---|<|-----+		  *
 *												 	             	 	 .	    |		  *
 *                                                              560      . \\   | 		  *
 *                                                       PC7 --/\/\/\-----|<|---+  		  *
 *																						  *
 *                                                                                        *
 *   Operation    : When Touch Key will Show Key Code on Heperterminal and LED PC[0..7]   *
 *													                                      *
 *																						  *
 ******************************************************************************************/




#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)

char Check_SHIF(void)   ;
char Check_TR(void)     ;
char RD_KeyCode(void)   ;

/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL,_FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);


//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
	  fputs("*ring*\n",stderr) ;
	  return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }

//------------------- Initial UART0 -----------------------

static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 104        ;     //Set Baud Rate 9600 : BURR= Fosc/[16x(9600)]-1
  
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter
   
   stdout = &uart_str ;     //Set address uart_str to stdout

 }


//*************************** Main *************************

int main (void) 
  { 
    
   unsigned int key ;                               

   //---------------Initial Port IO ----------------

   DDRA  = 0x00     ;        //Set PA0..PA7 = Input for Read Key Code BCD,Status key and Shift      
   DDRC  = 0xFF     ;        //Set PC0..PC7 = Output for Display Key Code
    
   PORTA = 0xFF     ;        //Set Default data 0xFF PortA = Pull-Up       
   PORTC = 0xFF     ;        //Set Default data 0xFF PortC = LED OFF   

   UART0_Init()     ;        //Initial Uart0

   
  printf("*******************************************************************************\r\n");    
  printf("**           Ex2.TEST READ KEY CODE BCD TOUCH PAD4x4 (SHIFT KEY)             **\r\n");        
  printf("*******************************************************************************\r\n"); 
 

  while(1)
  {

   	 if(!Check_TR())                             //Step1: Check  Touch key (Check_TR()=0:Touch,1:release) 
      {
		key  = RD_KeyCode()                   ;  //Step2: Read Key Code

        if( key == 0x0F)			             //Step3: Check Touch Key Shift(Touch the 1st Key) is Touch 2 Key
		 {
		    do
			 {
		      if(!Check_SHIF())	                  //Step3.1 : Check Touch Key Other(Touch the 2nd Key) by 0:touch,1: not touch
			   {		             
	             key = RD_KeyCode()            ;  //Step 3.2  Read Key Code for Key Shif+Key Other

			     //---------- Step3.3:Program Respond Touch 2key for user ------------

	             PORTC  = ~key					               ;   //Out Hex data key Code to LED PC[0..7]
			     PORTC &= 0x7F                                 ;   //Out Status Shif = 0 (ON-LED PC7)
	             printf("Key_Code BCD = Shift+0x0%X",key)      ;   //Print Key Code Out RS232
	             printf("\n\r")                                ;

		         while(!Check_SHIF()){;} 		   	           ;   //Wait Release 2Key (=1 exit loop) 
		      } 
			 }while(!Check_TR())                               ;   //Loop wait Touch the 2nd Key , Exit loop When release Key Shif or 2Key
		   
		 }
		else	                                //Step4: Check Touch Key Other don't key Shift is Touch 1 Key
		 { 
		   //---------- Step4.1:Program Respond Touch 1 key for user ------------
       
	       PORTC = ~key					           ;   //Out Hex data key Code to LED PC[0..7]
	       printf("Key_Code BCD = 0x0%X",key)      ;   //Print Key Code Out RS232
	       printf("\n\r")                          ;

		   while(!Check_TR()){;} 			       ;   //Wait Release Key (=1 exit loop) 	
		
		 }  
  
	  }	 //if of Check_ST()

    }	//while
  }     //main





 //******************************** Sub Program *********************************


//---------------------- Check Touch /Release for 2Key -------------------

char Check_SHIF(void)   
{
   char sh   ;
        
       sh  = PINA                ;   //Read Status Key
	   sh  = sh & 0x20           ;   //Mark bit PA5 (Statust Press or Release : 2Key)
	
	 if(sh != 0x20)           	     //Check Statue Key
	   return (0)                ;	 //Touch 2Key Return 0 (PA5=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(PA5=1)


}

//---------------------- Check Touch /Release 1Key -------------------

char Check_TR(void)    
 {
   char tr   ;
        
       tr  = PINA                ;   //Read Status Key
	   tr  = tr & 0x10           ;   //Mark bit PA4 (Statust Press or Release : 1 Key)
	
	 if(tr != 0x10)           	     //Check Statue Key
	   return (0)                ;	 //Touch Key Return 0 (PA4=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(PA4=1)
 }



//---------- Read BCD Key Code -----------------

 char RD_KeyCode(void) 
  {
	 unsigned int KeyCode                  ;
   
     KeyCode      = PINA                   ;   //Read Key Code
	 KeyCode      = KeyCode & 0x0F         ;   //Mark bit PA0-PA3(Key Code 4 bit)
	 return (KeyCode)                      ;
  }








